/*****************************************************
*** Author: Marco Olivares
*** www.mpa.com.mx
*****************************************************/

/* Rutina para control de memoria serial */

#include "PublicTypes.h"
#include "HWT.h"


#define salida   1
#define entrada  0
#define ACK      0
#define NACK     1


UINT8 byteout (volatile UINT8 byte_);
UINT8 bytein  (UINT8 Ack);
void  start   (void);
void  stop    (void);
void  Wait1ms (void);
void  readbytes (UINT8 device, UINT8 maxdata, UINT8 hi_add, UINT8 lo_add, UINT8 data[64]);


void scl_delay(void)
{
	UINT8 i;

	for (i = 0;i < 40;i++) ;
}

UINT8 byteout (volatile UINT8 byte_)
{
	UINT8 i;
	scldir = salida;
	sdadir = salida;
	scl = 0;

	for ( i = 0; i < 8; i++)
	{
		sda = (byte_ >> 7);
		scl = 1;
		scl_delay();
		byte_ = byte_ << 1;
		scl = 0;
		scl_delay();
	}

	sdadir = entrada;

	pu_sda = 1;
	scl = 0;
	scl = 1;
	scl_delay();
	byte_ = sda;
	scl = 0;
	sdadir = salida;
	sda = 0;
	return byte_;
}



UINT8 bytein  (UINT8 Ack)
{
	UINT8 i;
	UINT8 data = 0;
	scldir = salida;
	sdadir = entrada;
	pu_sda = 1;
	sda = 1;
	scl = 0;

	for ( i = 0; i < 8;i++)
	{
		scl = 1;
		scl_delay();
		data = data << 1;
		data = data | (UINT8) sda;
		scl = 0;
		scl_delay();
	}

	sdadir = salida;

	scl = 0;
	sda = Ack;
	scl = 1;
	scl_delay();
	scl = 0;
	sda = 0;
	return data;
}


void start (void)
{
	scldir = salida;
	sdadir = salida;
	scl = 0;
	sda = 1;
	scl = 1;
	scl_delay();
	sda = 0;
	scl = 0;
	scl_delay();
}

void stop (void)
{
	scldir = salida;
	sdadir = salida;
	scl = 0;
	sda = 0;
	scl = 1;
	scl_delay();
	sda = 1;
	scl = 0;
	sda = 0;
	scl_delay();
}


